#version 330 core

uniform float deltaTime;
uniform vec2  direction;
uniform sampler2D noise;

in vec4 POSITION;

void main()
{
	float scale = smoothstep(0.2, 0.6, 1.0 - POSITION.w) * deltaTime;
	float y_scale = smoothstep(0.2, 0.6, 1.0 - POSITION.w) * 0.25 * deltaTime;

	vec3 pos = POSITION.xyz*0.02;
	vec4 offset = textureLod(noise, pos.xz + vec2(pos.z*8.0, (pos.x + pos.y)*5.0), 0.0).rbga*2.0 - vec4(1.0);

	offset.xyz *= vec3(direction.x, 1.0, direction.y);
	offset.x *= scale;
	offset.y = (offset.y + 0.1)*y_scale;
	offset.z *= scale;

	offset.w = -(1.0/16.0)*deltaTime;

	gl_Position = POSITION + offset;
}
